/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.jndi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.lsc.LscDatasetModification;
import org.lsc.LscModifications;
import org.lsc.configuration.TaskType;
import org.lsc.exception.LscServiceConfigurationException;
import org.lsc.exception.LscServiceException;
import org.lsc.jndi.JndiModificationType;
import org.lsc.jndi.JndiModifications;
import org.lsc.jndi.SimpleJndiDstService;
import org.lsc.utils.CaseIgnoreStringHashMap;

public class ActiveDirectoryDstService
extends SimpleJndiDstService {
    final String MEMBER_OF_ATTR = "memberOf";
    final String GROUP_MEMBER_ATTR = "member";

    public ActiveDirectoryDstService(TaskType task) throws LscServiceConfigurationException {
        super(task);
    }

    @Override
    public boolean apply(LscModifications lm) throws LscServiceException {
        boolean success = true;
        LscDatasetModification memberOfDm = null;
        for (int i = 0; i < lm.getLscAttributeModifications().size(); ++i) {
            LscDatasetModification dm = lm.getLscAttributeModifications().get(i);
            if (!dm.getAttributeName().equals("memberOf")) continue;
            memberOfDm = dm;
            lm.getLscAttributeModifications().remove(i);
            break;
        }
        if (lm.getLscAttributeModifications().size() > 0 || lm.getNewMainIdentifier() != null) {
            success = super.apply(lm);
        }
        if (memberOfDm != null) {
            List<String> oldValues = this.getAttribute(lm.getMainIdentifier(), "memberOf");
            List<JndiModifications> memberOfChanges = this.computeChanges(lm.getMainIdentifier(), memberOfDm.getValues(), oldValues);
            try {
                for (JndiModifications jm : memberOfChanges) {
                    success &= this.jndiServices.apply(jm);
                }
            }
            catch (CommunicationException e) {
                throw new LscServiceException(e);
            }
        }
        return success;
    }

    protected List<JndiModifications> computeChanges(String userDn, List<?> newValues, List<?> oldValues) {
        ModificationItem modItem;
        JndiModifications jm;
        ArrayList<JndiModifications> results = new ArrayList<JndiModifications>();
        BasicAttribute attr = new BasicAttribute("member");
        attr.add(userDn);
        for (String groupDn : this.valuesDiff(newValues, oldValues)) {
            jm = new JndiModifications(JndiModificationType.MODIFY_ENTRY);
            jm.setDistinguishName(groupDn);
            modItem = new ModificationItem(1, attr);
            jm.setModificationItems(Arrays.asList(modItem));
            results.add(jm);
        }
        for (String groupDn : this.valuesDiff(oldValues, newValues)) {
            jm = new JndiModifications(JndiModificationType.MODIFY_ENTRY);
            jm.setDistinguishName(groupDn);
            modItem = new ModificationItem(3, attr);
            jm.setModificationItems(Arrays.asList(modItem));
            results.add(jm);
        }
        return results;
    }

    protected Set<String> valuesDiff(List<?> vals1, List<?> vals2) {
        CaseIgnoreStringHashMap diff = new CaseIgnoreStringHashMap();
        if (vals1 != null) {
            for (Object o : vals1) {
                diff.put(o.toString(), null);
            }
        }
        if (vals2 != null) {
            for (Object o : vals2) {
                diff.remove(o.toString());
            }
        }
        return diff.keySet();
    }

    protected List<String> getAttribute(String objectDn, String attribute) throws LscServiceException {
        ArrayList<String> values = null;
        try {
            SearchControls sc = new SearchControls();
            sc.setDerefLinkFlag(false);
            sc.setReturningAttributes(new String[]{attribute});
            sc.setSearchScope(0);
            sc.setReturningObjFlag(true);
            SearchResult res = this.jndiServices.getEntry(objectDn, "cn=*", sc);
            Attribute attr = res.getAttributes().get(attribute);
            if (attr != null) {
                values = new ArrayList<String>();
                NamingEnumeration<?> enu = attr.getAll();
                while (enu.hasMoreElements()) {
                    Object val = enu.next();
                    values.add(val.toString());
                }
            }
        }
        catch (NamingException e) {
            throw new LscServiceException(e);
        }
        return values;
    }
}

