/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.jndi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.collections.map.ListOrderedMap;
import org.lsc.LscDatasets;
import org.lsc.beans.IBean;
import org.lsc.configuration.TaskType;
import org.lsc.exception.LscServiceCommunicationException;
import org.lsc.exception.LscServiceException;
import org.lsc.exception.LscServiceInitializationException;
import org.lsc.jndi.AbstractSimpleJndiService;
import org.lsc.jndi.IJndiWritableService;
import org.lsc.jndi.JndiModifications;
import org.lsc.utils.StringLengthComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullDNJndiDstService
extends AbstractSimpleJndiService
implements IJndiWritableService {
    private Class<IBean> beanClass;
    private static final Logger LOGGER = LoggerFactory.getLogger(FullDNJndiDstService.class);

    @Deprecated
    public FullDNJndiDstService(Properties props, String beanClassName) throws LscServiceException {
        super(props);
        try {
            this.beanClass = Class.forName(beanClassName);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Bean class {} not found. Check this class name really exists.", (Object)beanClassName);
            throw new LscServiceInitializationException(e);
        }
    }

    public FullDNJndiDstService(TaskType task) throws LscServiceException {
        super(task.getLdapDestinationService());
        try {
            this.beanClass = Class.forName(task.getBean());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Bean class {} not found. Check this class name really exists.", (Object)task.getBean());
            throw new LscServiceInitializationException(e);
        }
    }

    @Override
    public IBean getBean(String dn, LscDatasets pivotAttributes, boolean fromSameService) throws LscServiceException {
        try {
            SearchControls sc = new SearchControls();
            sc.setSearchScope(0);
            List<String> attrs = this.getAttrs();
            if (attrs != null) {
                sc.setReturningAttributes(attrs.toArray(new String[attrs.size()]));
            }
            SearchResult srObject = this.getJndiServices().readEntry(dn, this.getFilterId(), true, sc);
            Method method = this.beanClass.getMethod("getInstance", SearchResult.class, String.class, Class.class);
            return (IBean)method.invoke(null, srObject, this.jndiServices.completeDn(dn), this.beanClass);
        }
        catch (SecurityException e) {
            LOGGER.error("Unable to get static method getInstance on {} ! This is probably a programmer's error ({})", (Object)this.beanClass.getName(), (Object)e);
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Unable to get static method getInstance on {} ! This is probably a programmer's error ({})", (Object)this.beanClass.getName(), (Object)e);
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Unable to get static method getInstance on {} ! This is probably a programmer's error ({})", (Object)this.beanClass.getName(), (Object)e);
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Unable to get static method getInstance on {} ! This is probably a programmer's error ({})", (Object)this.beanClass.getName(), (Object)e);
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Unable to get static method getInstance on {} ! This is probably a programmer's error ({})", (Object)this.beanClass.getName(), (Object)e);
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (NamingException e) {
            LOGGER.error("JNDI error while synchronizing {}: {} ", (Object)this.beanClass.getName(), (Object)e);
            LOGGER.debug(e.toString(), (Throwable)e);
            throw new LscServiceException(e.toString(), e);
        }
        return null;
    }

    @Override
    public Map<String, LscDatasets> getListPivots() throws LscServiceException {
        List<String> idList = null;
        try {
            idList = this.jndiServices.getDnList(this.getBaseDn(), this.getFilterAll(), 2);
            Collections.sort(idList, new StringLengthComparator());
        }
        catch (ClassCastException classCastException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (NamingException e) {
            throw new LscServiceException(e.toString(), e);
        }
        ListOrderedMap ids = new ListOrderedMap();
        for (String dn : idList) {
            String completedDn = this.jndiServices.completeDn(dn);
            LscDatasets attrs = new LscDatasets();
            attrs.put("dn", completedDn);
            ids.put(completedDn, attrs);
        }
        return ids;
    }

    @Override
    public boolean apply(JndiModifications jm) throws LscServiceCommunicationException {
        try {
            return this.jndiServices.apply(jm);
        }
        catch (CommunicationException e) {
            throw new LscServiceCommunicationException(e);
        }
    }
}

