/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.jndi;

import org.lsc.LscModificationType;

public enum JndiModificationType {
    ADD_ENTRY("create"),
    DELETE_ENTRY("delete"),
    MODIFY_ENTRY("update"),
    MODRDN_ENTRY("modrdn");

    private final String description;

    private JndiModificationType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static JndiModificationType getFromDescription(String desc) {
        JndiModificationType result = null;
        for (JndiModificationType type : JndiModificationType.values()) {
            if (!type.getDescription().matches(desc)) continue;
            result = type;
        }
        return result;
    }

    public static JndiModificationType getFromLscModificationType(LscModificationType lmt) {
        switch (lmt) {
            case CREATE_OBJECT: {
                return ADD_ENTRY;
            }
            case DELETE_OBJECT: {
                return DELETE_ENTRY;
            }
            case CHANGE_ID: {
                return MODRDN_ENTRY;
            }
        }
        return MODIFY_ENTRY;
    }
}

