/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.jndi;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KerberosCallbackHandler
implements CallbackHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(KerberosCallbackHandler.class);
    private String user;
    private String pass;

    public KerberosCallbackHandler(String user, String pass) {
        this.user = user;
        this.pass = pass;
    }

    @Override
    public void handle(Callback[] cbs) throws IOException, UnsupportedCallbackException {
        for (Callback cb : cbs) {
            if (cb instanceof NameCallback) {
                ((NameCallback)cb).setName(this.user);
                continue;
            }
            if (cb instanceof PasswordCallback) {
                ((PasswordCallback)cb).setPassword(this.pass.toCharArray());
                continue;
            }
            LOGGER.error("Unknown callback: " + cb.toString());
        }
    }
}

