/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.jndi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.lsc.jndi.JndiServices;
import org.lsc.jndi.ScriptableObject;

public class ScriptableJndiServices
extends ScriptableObject {
    private JndiServices jndiServices;

    public final void setJndiServices(JndiServices jndiServices) {
        this.jndiServices = jndiServices;
    }

    public final JndiServices getJndiServices() {
        return this.jndiServices;
    }

    public final List<String> search(Object base, Object filter) throws NamingException {
        return this.wrapString("_search", base, filter);
    }

    protected List<String> _search(String base, String filter) throws NamingException {
        return this.jndiServices.getDnList(base, filter, 2);
    }

    public final List<String> list(Object base, Object filter) throws NamingException {
        return this.wrapString("_list", base, filter);
    }

    protected final List<String> _list(String base, String filter) throws NamingException {
        return this.jndiServices.getDnList(base, filter, 1);
    }

    public final List<String> read(Object base, Object filter) throws NamingException {
        return this.wrapString("_read", base, filter);
    }

    protected List<String> _read(String base, String filter) throws NamingException {
        return this.jndiServices.getDnList(base, filter, 0);
    }

    public final List<String> exists(Object dn, Object filter) throws NamingException {
        return this.wrapString("_exists", dn, filter);
    }

    public final List<String> exists(Object dn) throws NamingException {
        return this.wrapString("_exists", dn, "objectClass=*");
    }

    protected List<String> _exists(String dn, String filter) throws NamingException {
        if (this.jndiServices.exists(dn, filter)) {
            ArrayList<String> c = new ArrayList<String>();
            c.add(dn);
            return c;
        }
        return null;
    }

    public final List<String> or(Object a, Object b) throws NamingException {
        return this.wrapList("_or", a, b);
    }

    protected final List<String> _or(List<String> a, List<String> b) throws NamingException {
        ArrayList<String> c = new ArrayList<String>();
        if (a != null) {
            c.addAll(a);
        }
        if (b != null) {
            c.addAll(b);
        }
        return c;
    }

    public final List<String> attribute(Object base, Object attrName) throws NamingException {
        return this.wrapString("_attr", base, attrName);
    }

    protected List<String> _attr(String base, String attrName) throws NamingException {
        SearchControls sc = new SearchControls();
        sc.setReturningAttributes(new String[]{attrName});
        SearchResult sr = this.jndiServices.readEntry(base, "objectClass=*", false, sc);
        if (sr != null && sr.getAttributes() != null && sr.getAttributes().get(attrName) != null) {
            return Collections.list(sr.getAttributes().get(attrName).getAll());
        }
        return null;
    }

    public final List<String> and(Object a, Object b) throws NamingException {
        return this.wrapList("_and", a, b);
    }

    protected List<String> _and(List<String> aList, List<String> bList) throws NamingException {
        ArrayList<String> cList = new ArrayList<String>();
        if (aList.size() < bList.size()) {
            for (String tmp : aList) {
                if (!bList.contains(tmp)) continue;
                cList.add(tmp);
            }
        } else {
            for (String tmp : bList) {
                if (!aList.contains(tmp)) continue;
                cList.add(tmp);
            }
        }
        return cList;
    }

    public final List<String> retain(Object a, Object b) throws NamingException {
        return this.wrapList("_retain", a, b);
    }

    protected List<String> _retain(List<String> aList, List<String> bList) throws NamingException {
        ArrayList<String> cList = new ArrayList<String>();
        for (String aValue : aList) {
            if (bList.contains(aValue)) continue;
            cList.add(aValue);
        }
        return cList;
    }

    public final List<String> sup(Object dn, Object level) throws NamingException {
        return this.wrapString("_sup", dn, level);
    }

    protected List<String> _sup(String dn, String level) throws NamingException {
        int levelValue = Integer.parseInt(level);
        return this.jndiServices.sup(dn, levelValue);
    }

    public final List<String> fsup(Object dn, Object filter) throws NamingException {
        return this.wrapString("_fsup", dn, filter);
    }

    protected List<String> _fsup(String dn, String filter) throws NamingException {
        ArrayList<String> cList = new ArrayList<String>();
        List<String> dns = this.jndiServices.sup(dn, 0);
        if (dns == null) {
            return null;
        }
        for (String aDn : dns) {
            if (!this.jndiServices.exists(aDn, filter)) continue;
            cList.add(aDn);
            return cList;
        }
        return cList;
    }

    public String getContextDn() {
        return this.jndiServices.getContextDn();
    }
}

