/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import org.lsc.jndi.JndiServices;
import org.lsc.jndi.parser.LdapAttributeType;
import org.lsc.jndi.parser.LdapObjectClass;
import org.lsc.service.DataSchemaProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiDataSchemaProvider
implements DataSchemaProvider {
    public static final Logger LOGGER = LoggerFactory.getLogger(JndiDataSchemaProvider.class);
    private List<String> objectClasses;
    private List<String> attributeTypes;
    private LdapObjectClass ldapObjectClass;
    private Map<String, LdapAttributeType> ldapAttributeTypes;

    public JndiDataSchemaProvider(JndiServices js, String className) throws NamingException {
        Map<String, List<String>> ocsTemp = js.getSchema(new String[]{"objectclasses"});
        Map<String, List<String>> atsTemp = js.getSchema(new String[]{"attributetypes"});
        if (ocsTemp == null || ocsTemp.keySet().size() == 0 || atsTemp == null || atsTemp.keySet().size() == 0) {
            LOGGER.error("Unable to read objectclasses or attributetypes in ldap schema! Exiting...");
            return;
        }
        this.objectClasses = this.filterNames(ocsTemp.values().iterator().next());
        this.attributeTypes = this.filterNames(atsTemp.values().iterator().next());
        this.ldapAttributeTypes = new HashMap<String, LdapAttributeType>();
        for (String atStr : this.attributeTypes) {
            LdapAttributeType lat = LdapAttributeType.parse(atStr);
            if (lat == null) continue;
            this.ldapAttributeTypes.put(lat.getName(), lat);
        }
        for (String ocStr : this.objectClasses) {
            LdapObjectClass loc = LdapObjectClass.parse(ocStr, this.ldapAttributeTypes);
            if (loc == null || loc.getName().compareToIgnoreCase(className) != 0) continue;
            this.ldapObjectClass = loc;
            break;
        }
    }

    private List<String> filterNames(List<String> names) {
        ArrayList<String> filteredNames = new ArrayList<String>();
        for (String name : names) {
            String filteredName = this.filterName(name);
            if (filteredName.length() != 0) {
                filteredNames.add(filteredName);
                continue;
            }
            LOGGER.error("Name invalid: {}. Attributes or object class not generated !!!", (Object)name);
        }
        return filteredNames;
    }

    private String filterName(String name) {
        String REGEX = "^\\p{Alpha}[\\w]*$";
        Pattern p = Pattern.compile(REGEX);
        Matcher m = p.matcher(name);
        if (m.matches()) {
            return "";
        }
        return name;
    }

    @Override
    public Collection<String> getElementsName() {
        return this.ldapAttributeTypes.keySet();
    }

    @Override
    public Class<?> getElementSingleType(String elementName) {
        return String.class;
    }

    @Override
    public boolean isElementMandatory(String elementName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isElementMultivalued(String elementName) {
        if (!this.ldapObjectClass.getMonoAttrs().contains(elementName) && !this.ldapObjectClass.getMultiAttrs().contains(elementName)) {
            throw new MissingFormatArgumentException("Unknown attribute: " + elementName);
        }
        return this.ldapObjectClass.getMultiAttrs().contains(elementName);
    }
}

