/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.service;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.lsc.Configuration;
import org.lsc.LscDatasets;
import org.lsc.configuration.DatabaseConnectionType;
import org.lsc.configuration.DatabaseSourceServiceType;
import org.lsc.configuration.TaskType;
import org.lsc.exception.LscConfigurationException;
import org.lsc.exception.LscServiceConfigurationException;
import org.lsc.exception.LscServiceException;
import org.lsc.exception.LscServiceInitializationException;
import org.lsc.persistence.DaoConfig;
import org.lsc.service.AbstractJdbcService;
import org.lsc.service.IAsynchronousService;

public class SimpleJdbcSrcService
extends AbstractJdbcService
implements IAsynchronousService {
    private final String requestNameForList;
    private final String requestNameForNextId;
    private final String requestNameForObject;
    private final String requestNameForClean;
    private int interval;
    static int count = 0;

    @Deprecated
    public SimpleJdbcSrcService(Properties props, String beanClassName) throws LscServiceException {
        super(DaoConfig.getSqlMapClient(Configuration.getAsProperties("src.database")), beanClassName);
        this.requestNameForList = props.getProperty("requestNameForList");
        this.requestNameForObject = props.getProperty("requestNameForObject");
        this.requestNameForNextId = props.getProperty("requestNameForNextId");
        this.requestNameForClean = props.getProperty("requestNameForClean");
        try {
            Configuration.assertPropertyNotEmpty("requestNameForList", this.requestNameForList, this.getClass().getName());
            Configuration.assertPropertyNotEmpty("requestNameForObject", this.requestNameForObject, this.getClass().getName());
            this.interval = props.getProperty("interval") != null ? Integer.parseInt(props.getProperty("interval")) : -1;
        }
        catch (NumberFormatException e) {
            throw new LscServiceInitializationException(e);
        }
        catch (LscConfigurationException e) {
            throw new LscServiceConfigurationException(e);
        }
    }

    public SimpleJdbcSrcService(TaskType task) throws LscServiceException {
        super((DatabaseConnectionType)task.getDatabaseSourceService().getConnection().getReference(), task.getBean());
        DatabaseSourceServiceType serviceConf = task.getDatabaseSourceService();
        this.requestNameForList = serviceConf.getRequestNameForList();
        this.requestNameForObject = serviceConf.getRequestNameForObject();
        this.requestNameForNextId = serviceConf.getRequestNameForNextId();
        this.requestNameForClean = serviceConf.getRequestNameForClean();
        if (this.requestNameForClean == null) {
            LOGGER.warn("No clean request has been specified for task=" + task.getName() + ". During the clean phase, LSC wouldn't be able to get the right entries and may delete all destination entries !");
        }
        this.interval = (serviceConf.getInterval() != null ? serviceConf.getInterval() : 5) * 1000;
    }

    @Override
    public String getRequestNameForList() {
        return this.requestNameForList;
    }

    @Override
    public String getRequestNameForObject() {
        return this.requestNameForObject;
    }

    @Override
    public String getRequestNameForNextId() {
        return this.requestNameForNextId;
    }

    @Override
    public String getRequestNameForClean() {
        return this.requestNameForClean;
    }

    @Override
    public String getRequestNameForObjectOrClean(boolean fromSameService) {
        if (fromSameService) {
            return this.getRequestNameForObject();
        }
        return this.getRequestNameForClean();
    }

    @Override
    public Map.Entry<String, LscDatasets> getNextId() {
        try {
            Map idMap = (Map)this.sqlMapper.queryForObject(this.getRequestNameForNextId());
            String key = this.getMapKey(idMap, count++);
            HashMap<String, LscDatasets> ret = new HashMap<String, LscDatasets>();
            ret.put(key, new LscDatasets(idMap));
            return ret.entrySet().iterator().next();
        }
        catch (SQLException e) {
            LOGGER.warn("Error while looking for next entry ({})", (Throwable)e);
            LOGGER.debug(e.toString(), (Throwable)e);
            return null;
        }
    }

    @Override
    public long getInterval() {
        return this.interval;
    }
}

