/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.service;

import java.io.Closeable;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.TrustManagerFactory;
import org.apache.directory.api.ldap.codec.api.BinaryAttributeDetector;
import org.apache.directory.api.ldap.codec.api.DefaultConfigurableBinaryAttributeDetector;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.SearchResultEntryDecorator;
import org.apache.directory.api.ldap.codec.osgi.DefaultLdapCodecService;
import org.apache.directory.api.ldap.extras.controls.SynchronizationModeEnum;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncState.SyncStateTypeEnum;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncState.SyncStateValue;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncRequestValueDecorator;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.message.controls.AbstractControl;
import org.apache.directory.api.ldap.model.message.controls.PersistentSearch;
import org.apache.directory.api.ldap.model.message.controls.PersistentSearchImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.ldap.client.api.LdapAsyncConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.ldap.client.api.future.SearchFuture;
import org.lsc.LscDatasets;
import org.lsc.beans.IBean;
import org.lsc.configuration.AsyncLdapSourceServiceType;
import org.lsc.configuration.LdapConnectionType;
import org.lsc.configuration.LdapDerefAliasesType;
import org.lsc.configuration.LdapServerType;
import org.lsc.configuration.TaskType;
import org.lsc.exception.LscServiceCommunicationException;
import org.lsc.exception.LscServiceConfigurationException;
import org.lsc.exception.LscServiceException;
import org.lsc.jndi.SimpleJndiSrcService;
import org.lsc.service.IAsynchronousService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncReplSourceService
extends SimpleJndiSrcService
implements IAsynchronousService,
Closeable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SyncReplSourceService.class);
    private LdapAsyncConnection connection;
    private LdapConnectionType ldapConn;
    private AsyncLdapSourceServiceType srsc;
    private int interval;
    private SearchFuture sf;

    public SyncReplSourceService(TaskType task) throws LscServiceConfigurationException {
        super(task);
        this.srsc = task.getAsyncLdapSourceService();
        this.interval = (this.srsc.getInterval() != null ? this.srsc.getInterval() : 5) * 1000;
        this.ldapConn = (LdapConnectionType)this.srsc.getConnection().getReference();
        this.connection = SyncReplSourceService.getConnection(this.ldapConn);
    }

    public static LdapAsyncConnection getConnection(LdapConnectionType ldapConn) throws LscServiceConfigurationException {
        try {
            LdapUrl url = new LdapUrl(ldapConn.getUrl());
            boolean isLdaps = "ldaps://".equalsIgnoreCase(url.getScheme());
            int port = url.getPort();
            if (port == -1) {
                port = isLdaps ? 636 : 389;
            }
            LdapNetworkConnection conn = new LdapNetworkConnection(url.getHost(), port);
            LdapConnectionConfig lcc = conn.getConfig();
            lcc.setUseSsl(isLdaps);
            lcc.setUseTls(ldapConn.isTlsActivated().booleanValue());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            lcc.setTrustManagers(tmf.getTrustManagers());
            if (ldapConn.getBinaryAttributes() != null) {
                DefaultConfigurableBinaryAttributeDetector bad = new DefaultConfigurableBinaryAttributeDetector();
                bad.addBinaryAttribute(ldapConn.getBinaryAttributes().getString().toArray(new String[0]));
                lcc.setBinaryAttributeDetector((BinaryAttributeDetector)bad);
            }
            if (conn.connect()) {
                conn.bind(ldapConn.getUsername(), ldapConn.getPassword());
                return conn;
            }
            return null;
        }
        catch (LdapException e) {
            throw new LscServiceConfigurationException(e.toString(), (Exception)((Object)e));
        }
        catch (NoSuchAlgorithmException e) {
            throw new LscServiceConfigurationException(e.toString(), e);
        }
        catch (KeyStoreException e) {
            throw new LscServiceConfigurationException(e.toString(), e);
        }
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }

    @Override
    public Map<String, LscDatasets> getListPivots() throws LscServiceException {
        try {
            return this.convertSearchEntries(this.connection.search(this.getBaseDn(), this.getFilterAll(), SearchScope.SUBTREE, this.getAttrsId().toArray(new String[this.getAttrsId().size()])));
        }
        catch (RuntimeException e) {
            throw new LscServiceException(e.toString(), e);
        }
        catch (LdapException e) {
            throw new LscServiceException(e.toString(), (Exception)((Object)e));
        }
    }

    @Override
    public IBean getBean(String id, LscDatasets pivotAttrs, boolean fromSameService) throws LscServiceException {
        IBean srcBean = null;
        String searchString = null;
        searchString = fromSameService || this.filterIdClean == null ? this.filterIdSync : this.filterIdClean;
        searchString = Pattern.compile("\\{id\\}", 2).matcher(searchString).replaceAll(Matcher.quoteReplacement(id));
        if (pivotAttrs != null && pivotAttrs.getDatasets() != null && pivotAttrs.getDatasets().size() > 0) {
            for (String attributeName : pivotAttrs.getAttributesNames()) {
                String valueId = pivotAttrs.getValueForFilter(attributeName.toLowerCase());
                searchString = Pattern.compile("\\{" + attributeName + "\\}", 2).matcher(searchString).replaceAll(Matcher.quoteReplacement(valueId));
            }
        } else {
            searchString = this.attrsId.size() == 1 ? Pattern.compile("\\{" + (String)this.attrsId.get(0) + "\\}", 2).matcher(searchString).replaceAll(Matcher.quoteReplacement(id)) : this.filterIdSync.replaceAll("\\{0\\}", id);
        }
        try {
            SearchScope searchScope;
            EntryCursor entryCursor = null;
            String searchBaseDn = fromSameService ? id : this.baseDn;
            SearchScope searchScope2 = searchScope = fromSameService ? SearchScope.OBJECT : SearchScope.SUBTREE;
            if (this.getAttrs() != null) {
                ArrayList<String> attrList = new ArrayList<String>(this.getAttrs());
                attrList.addAll(pivotAttrs.getAttributesNames());
                entryCursor = this.connection.search(searchBaseDn, searchString, searchScope, attrList.toArray(new String[attrList.size()]));
            } else {
                entryCursor = this.connection.search(searchBaseDn, searchString, searchScope, new String[0]);
            }
            srcBean = (IBean)this.beanClass.newInstance();
            entryCursor.next();
            if (!entryCursor.available()) {
                return null;
            }
            Entry entry = (Entry)entryCursor.get();
            srcBean.setMainIdentifier(entry.getDn().getName());
            srcBean.setDatasets(this.convertEntry(entry));
            entryCursor.getSearchResultDone();
            entryCursor.close();
            return srcBean;
        }
        catch (InstantiationException e) {
            LOGGER.error("Bad class name: " + this.beanClass.getName() + "(" + e + ")");
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Bad class name: " + this.beanClass.getName() + "(" + e + ")");
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("LDAP error while reading entry " + id + " (" + e + ")");
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        return null;
    }

    @Override
    public Map.Entry<String, LscDatasets> getNextId() throws LscServiceException {
        HashMap<String, LscDatasets> temporaryMap = new HashMap<String, LscDatasets>(1);
        if (this.sf == null || this.sf.isCancelled()) {
            try {
                SearchRequestImpl searchRequest = new SearchRequestImpl();
                searchRequest.addControl(SyncReplSourceService.getSearchContinuationControl(this.srsc.getServerType()));
                searchRequest.setBase(new Dn(new String[]{this.getBaseDn()}));
                searchRequest.setFilter(this.getFilterAll());
                searchRequest.setDerefAliases(this.getAlias(this.ldapConn.getDerefAliases()));
                searchRequest.setScope(SearchScope.SUBTREE);
                searchRequest.addAttributes(this.getAttrsId().toArray(new String[this.getAttrsId().size()]));
                this.sf = SyncReplSourceService.getConnection(this.ldapConn).searchAsync((SearchRequest)searchRequest);
            }
            catch (LdapInvalidDnException e) {
                throw new LscServiceException(e.toString(), (Exception)((Object)e));
            }
            catch (LdapException e) {
                throw new LscServiceException(e.toString(), (Exception)((Object)e));
            }
        }
        Response searchResponse = null;
        try {
            searchResponse = this.sf.get(1L, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted search !");
        }
        catch (ExecutionException e) {
            LOGGER.warn("Execution exception while searching !");
        }
        catch (TimeoutException e) {
            LOGGER.warn("Timeout during search !");
        }
        if (this.checkSearchResponse(searchResponse)) {
            SearchResultEntryDecorator sre = (SearchResultEntryDecorator)searchResponse;
            temporaryMap.put(sre.getObjectName().toString(), this.convertEntry(sre.getEntry(), true));
            return temporaryMap.entrySet().iterator().next();
        }
        if (searchResponse != null && searchResponse.getType() == MessageTypeEnum.SEARCH_RESULT_DONE) {
            LdapResult result = ((SearchResultDone)searchResponse).getLdapResult();
            if (result.getResultCode() != ResultCodeEnum.SUCCESS) {
                throw new LscServiceCommunicationException(result.getDiagnosticMessage(), null);
            }
            this.sf = null;
        }
        return null;
    }

    private boolean checkSearchResponse(Response searchResponse) {
        if (searchResponse == null || searchResponse.getType() != MessageTypeEnum.SEARCH_RESULT_ENTRY) {
            return false;
        }
        SyncStateValue syncStateCtrl = (SyncStateValue)searchResponse.getControl("1.3.6.1.4.1.4203.1.9.1.2");
        return syncStateCtrl == null || syncStateCtrl.getSyncStateType() != SyncStateTypeEnum.DELETE;
    }

    private AliasDerefMode getAlias(LdapDerefAliasesType aliasesHandling) {
        switch (aliasesHandling) {
            case ALWAYS: {
                return AliasDerefMode.DEREF_ALWAYS;
            }
            case FIND: {
                return AliasDerefMode.DEREF_FINDING_BASE_OBJ;
            }
            case SEARCH: {
                return AliasDerefMode.DEREF_IN_SEARCHING;
            }
        }
        return AliasDerefMode.NEVER_DEREF_ALIASES;
    }

    public static Control getSearchContinuationControl(LdapServerType serverType) throws LscServiceConfigurationException {
        switch (serverType) {
            case OPEN_LDAP: 
            case APACHE_DS: {
                DefaultLdapCodecService codec = new DefaultLdapCodecService();
                SyncRequestValueDecorator syncControl = new SyncRequestValueDecorator((LdapApiService)codec);
                syncControl.setMode(SynchronizationModeEnum.REFRESH_AND_PERSIST);
                return syncControl;
            }
            case OPEN_DS: 
            case OPEN_DJ: 
            case ORACLE_DS: 
            case SUN_DS: 
            case NETSCAPE_DS: 
            case NOVELL_E_DIRECTORY: {
                PersistentSearchImpl searchControl = new PersistentSearchImpl();
                searchControl.setCritical(true);
                searchControl.setChangesOnly(true);
                searchControl.setReturnECs(false);
                searchControl.setChangeTypes(PersistentSearch.CHANGE_TYPES_MAX);
                return searchControl;
            }
            case ACTIVE_DIRECTORY: {
                return new AbstractControl("1.2.840.113556.1.4.528", true){};
            }
        }
        throw new LscServiceConfigurationException("Unknown or unsupported server type !");
    }

    private LscDatasets convertEntry(Entry entry) {
        return this.convertEntry(entry, false);
    }

    private LscDatasets convertEntry(Entry entry, boolean onlyFirstValue) {
        if (entry == null) {
            return null;
        }
        LscDatasets converted = new LscDatasets();
        for (Attribute attr : entry) {
            if (attr == null || attr.size() <= 0) continue;
            Iterator values = attr.iterator();
            if (!onlyFirstValue) {
                HashSet<Object> datasetsValues = new HashSet<Object>();
                while (values.hasNext()) {
                    Value value = (Value)values.next();
                    if (value.isHumanReadable()) {
                        datasetsValues.add(value.getString());
                        continue;
                    }
                    datasetsValues.add(value.getBytes());
                }
                converted.getDatasets().put(attr.getId(), datasetsValues);
                continue;
            }
            Value value = (Value)values.next();
            converted.getDatasets().put(attr.getId(), value.isHumanReadable() ? value.getString() : (Object)value.getBytes());
        }
        return converted;
    }

    private Map<String, LscDatasets> convertSearchEntries(EntryCursor entryCursor) throws LscServiceException {
        HashMap<String, LscDatasets> converted = new HashMap<String, LscDatasets>();
        try {
            while (entryCursor.next()) {
                Entry entry = (Entry)entryCursor.get();
                converted.put(entry.getDn().getName(), this.convertEntry(entry));
            }
            entryCursor.getSearchResultDone();
        }
        catch (Exception e) {
            throw new LscServiceException("Error while performing search. Results may be incomplete." + e, e);
        }
        return converted;
    }

    @Override
    public long getInterval() {
        return this.interval;
    }
}

