/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.io.FilenameUtils;
import org.lsc.Task;
import org.lsc.beans.IBean;
import org.lsc.exception.LscServiceException;
import org.lsc.jndi.AbstractSimpleJndiService;
import org.lsc.jndi.ScriptableJndiServices;
import org.lsc.utils.ScriptableEvaluator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.UniqueTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JScriptEvaluator
implements ScriptableEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JScriptEvaluator.class);
    private ScriptEngine engine;

    public JScriptEvaluator(ScriptEngine se) {
        this.engine = se;
    }

    @Override
    public String evalToString(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        Object result = this.instanceEval(task, expression, params);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return (String)result;
        }
        return result.toString();
    }

    @Override
    public List<String> evalToStringList(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        Object result = null;
        try {
            result = JScriptEvaluator.convertJsToJava(this.instanceEval(task, expression, params));
        }
        catch (EvaluatorException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
        if (result instanceof String[] || result instanceof Object[]) {
            ArrayList<String> resultsArray = new ArrayList<String>();
            for (Object resultValue : (Object[])result) {
                resultsArray.add(resultValue.toString());
            }
            return resultsArray;
        }
        if (result instanceof String) {
            ArrayList<String> resultsArray = new ArrayList<String>();
            String resultAsString = (String)result;
            if (resultAsString != null && resultAsString.length() > 0) {
                resultsArray.add(resultAsString);
            }
            return resultsArray;
        }
        if (result instanceof List) {
            ArrayList<String> resultsArray = new ArrayList<String>();
            for (Object resultValue : (List)result) {
                resultsArray.add(resultValue.toString());
            }
            return resultsArray;
        }
        if (result == null) {
            return null;
        }
        ArrayList<String> resultsArray = new ArrayList<String>();
        if (result != null) {
            resultsArray.add(result.toString());
        }
        return resultsArray;
    }

    @Override
    public List<byte[]> evalToByteArrayList(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        Object result = null;
        try {
            result = JScriptEvaluator.convertJsToJava(this.instanceEval(task, expression, params));
        }
        catch (EvaluatorException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
        if (result instanceof byte[][]) {
            ArrayList<byte[]> resultsArray = new ArrayList<byte[]>();
            for (byte[] resultValue : (byte[][])result) {
                resultsArray.add(resultValue);
            }
            return resultsArray;
        }
        if (result instanceof byte[]) {
            ArrayList<byte[]> resultsArray = new ArrayList<byte[]>();
            byte[] resultAsByteArray = (byte[])result;
            if (resultAsByteArray != null && resultAsByteArray.length > 0) {
                resultsArray.add(resultAsByteArray);
            }
            return resultsArray;
        }
        if (result instanceof String) {
            ArrayList<byte[]> resultsArray = new ArrayList<byte[]>();
            String resultAsString = (String)result;
            if (resultAsString != null && resultAsString.length() > 0) {
                resultsArray.add(resultAsString.getBytes());
            }
            return resultsArray;
        }
        if (result instanceof List) {
            ArrayList<byte[]> resultsArray = new ArrayList<byte[]>();
            for (Object resultValue : (List)result) {
                if (resultValue instanceof byte[]) {
                    resultsArray.add((byte[])resultValue);
                    continue;
                }
                resultsArray.add(resultValue.toString().getBytes());
            }
            return resultsArray;
        }
        if (result instanceof Set) {
            ArrayList<byte[]> resultsArray = new ArrayList<byte[]>();
            for (Object resultValue : (Set)result) {
                if (resultValue instanceof byte[]) {
                    resultsArray.add((byte[])resultValue);
                    continue;
                }
                resultsArray.add(resultValue.toString().getBytes());
            }
            return resultsArray;
        }
        if (result == null) {
            return null;
        }
        ArrayList<byte[]> resultsArray = new ArrayList<byte[]>();
        if (result != null) {
            resultsArray.add(result.toString().getBytes());
        }
        return resultsArray;
    }

    @Override
    public byte[] evalToByteArray(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        Object result = null;
        try {
            result = JScriptEvaluator.convertJsToJava(this.instanceEval(task, expression, params));
        }
        catch (EvaluatorException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
        if (result instanceof byte[]) {
            return (byte[])result;
        }
        if (result instanceof String) {
            return ((String)result).getBytes();
        }
        return result.toString().getBytes();
    }

    @Override
    public Boolean evalToBoolean(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        try {
            return (Boolean)Context.jsToJava((Object)this.instanceEval(task, expression, params), Boolean.class);
        }
        catch (EvaluatorException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
    }

    private Object instanceEval(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        Bindings bindings = this.engine.createBindings();
        String expressionImport = "var version = java.lang.System.getProperty(\"java.version\");\nif (version.startsWith(\"1.8.0\")) { load(\"nashorn:mozilla_compat.js\"); }\nimportPackage(org.lsc.utils.directory);\nimportPackage(org.lsc.utils);\n" + expression;
        if (!bindings.containsKey("ldap") && task.getDestinationService() instanceof AbstractSimpleJndiService) {
            ScriptableJndiServices dstSjs = new ScriptableJndiServices();
            dstSjs.setJndiServices(((AbstractSimpleJndiService)((Object)task.getDestinationService())).getJndiServices());
            bindings.put("ldap", (Object)dstSjs);
        }
        if (!bindings.containsKey("srcLdap") && task.getSourceService() instanceof AbstractSimpleJndiService) {
            ScriptableJndiServices srcSjs = new ScriptableJndiServices();
            srcSjs.setJndiServices(((AbstractSimpleJndiService)((Object)task.getSourceService())).getJndiServices());
            bindings.put("srcLdap", (Object)srcSjs);
        }
        if (params != null) {
            for (String string : params.keySet()) {
                bindings.put(string, params.get(string));
            }
        }
        Object ret = null;
        try {
            if (task.getScriptIncludes() != null) {
                for (File scriptInclude : task.getScriptIncludes()) {
                    if (!"js".equals(FilenameUtils.getExtension((String)scriptInclude.getAbsolutePath()))) continue;
                    this.engine.eval((Reader)new FileReader(scriptInclude), bindings);
                }
            }
            ret = this.engine.eval(expressionImport, bindings);
        }
        catch (ScriptException scriptException) {
            LOGGER.error("Fail to compute expression: " + expression + " on " + (params.containsKey("srcBean") && ((IBean)params.get("srcBean")).getMainIdentifier() != null ? "id=" + ((IBean)params.get("srcBean")).getMainIdentifier() : (params.containsKey("dstBean") && ((IBean)params.get("dstBean")).getMainIdentifier() != null ? "id=" + ((IBean)params.get("dstBean")).getMainIdentifier() : "unknown id !")) + "\nReason: " + scriptException.toString());
            LOGGER.debug(scriptException.toString(), (Throwable)scriptException);
            throw new LscServiceException(scriptException);
        }
        catch (RuntimeException runtimeException) {
            throw new LscServiceException(runtimeException);
        }
        catch (Exception exception) {
            LOGGER.error(exception.toString());
            LOGGER.debug(exception.toString(), (Throwable)exception);
            return null;
        }
        return ret;
    }

    private static Object convertJsToJava(Object src) {
        if (src == null) {
            return null;
        }
        if (src.getClass().getName().equals("sun.org.mozilla.javascript.internal.NativeJavaObject")) {
            return Context.jsToJava((Object)src, Object.class);
        }
        if (src.getClass().getName().equals("sun.org.mozilla.javascript.internal.NativeArray")) {
            try {
                Method getMethod = src.getClass().getMethod("get", Integer.TYPE, Class.forName("sun.org.mozilla.javascript.internal.Scriptable"));
                Object length = src.getClass().getMethod("getLength", new Class[0]).invoke(src, new Object[0]);
                Object[] retarr = new Object[Integer.parseInt(length.toString())];
                for (int index = 0; index < retarr.length; ++index) {
                    retarr[index] = getMethod.invoke(src, index, null);
                }
                return retarr;
            }
            catch (Exception e) {
                LOGGER.error(e.toString());
                LOGGER.debug(e.toString(), (Throwable)e);
            }
        } else if (src instanceof Bindings) {
            try {
                Method values;
                Object vals;
                Method isArray;
                Object result;
                Class<?> cls = Class.forName("jdk.nashorn.api.scripting.ScriptObjectMirror");
                if (cls.isAssignableFrom(src.getClass()) && (result = (isArray = cls.getMethod("isArray", new Class[0])).invoke(src, new Object[0])) != null && result.equals(true) && (vals = (values = cls.getMethod("values", new Class[0])).invoke(src, new Object[0])) instanceof Collection) {
                    Collection coll = (Collection)vals;
                    return coll.toArray(new Object[0]);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.toString());
                LOGGER.debug(e.toString(), (Throwable)e);
            }
        } else {
            if (src instanceof List) {
                List list = (List)src;
                return list.toArray(new Object[0]);
            }
            if (src == UniqueTag.NOT_FOUND || src == UniqueTag.NULL_VALUE) {
                return null;
            }
        }
        return src;
    }
}

