/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PidUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PidUtil.class);

    public static String getPID(String fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Long.toString(Long.parseLong(jvmName.substring(0, index)));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public static String getPID() {
        String pid = System.getProperty("pid");
        try {
            if (pid == null) {
                if (System.getProperty("os.name").toLowerCase().indexOf("windows") == -1) {
                    Process p = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "echo $$ $PPID"});
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    PidUtil.pump(p.getInputStream(), bout, false, true);
                    StringTokenizer stok = new StringTokenizer(bout.toString());
                    stok.nextToken();
                    pid = stok.nextToken();
                } else {
                    pid = PidUtil.getPID(null);
                }
                if (pid != null) {
                    System.setProperty("pid", pid);
                }
            }
        }
        catch (IOException e) {
            LOGGER.debug("Exception: " + e.toString());
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pump(InputStream in, OutputStream out, boolean closeIn, boolean closeOut) throws IOException {
        byte[] bytes = new byte[1024];
        try {
            int read;
            while ((read = in.read(bytes)) != -1) {
                out.write(bytes, 0, read);
            }
        }
        finally {
            if (closeIn && in != null) {
                in.close();
            }
            if (closeOut && out != null) {
                out.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println(PidUtil.getPID());
    }
}

