/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.lsc.Task;
import org.lsc.exception.LscServiceException;
import org.lsc.jndi.AbstractSimpleJndiService;
import org.lsc.jndi.ScriptableJndiServices;
import org.lsc.utils.RhinoDebugger;
import org.lsc.utils.ScriptableEvaluator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RhinoJScriptEvaluator
implements ScriptableEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RhinoJScriptEvaluator.class);
    private Context cx;
    private boolean debug;

    public RhinoJScriptEvaluator(boolean debug) {
        this.debug = debug;
    }

    @Override
    public String evalToString(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        Object result = this.instanceEval(task, expression, params);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return (String)result;
        }
        return result.toString();
    }

    @Override
    public List<String> evalToStringList(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        Object result = null;
        try {
            result = RhinoJScriptEvaluator.convertJsToJava(this.instanceEval(task, expression, params));
        }
        catch (EvaluatorException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
        if (result instanceof String[] || result instanceof Object[]) {
            ArrayList<String> resultsArray = new ArrayList<String>();
            for (Object resultValue : (Object[])result) {
                resultsArray.add(resultValue.toString());
            }
            return resultsArray;
        }
        if (result instanceof String) {
            ArrayList<String> resultsArray = new ArrayList<String>();
            String resultAsString = (String)result;
            if (resultAsString != null && resultAsString.length() > 0) {
                resultsArray.add(resultAsString);
            }
            return resultsArray;
        }
        if (result instanceof List) {
            ArrayList<String> resultsArray = new ArrayList<String>();
            for (Object resultValue : (List)result) {
                resultsArray.add(resultValue.toString());
            }
            return resultsArray;
        }
        if (result == null) {
            return null;
        }
        ArrayList<String> resultsArray = new ArrayList<String>();
        if (result != null) {
            resultsArray.add(result.toString());
        }
        return resultsArray;
    }

    @Override
    public List<byte[]> evalToByteArrayList(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        Object result = null;
        try {
            result = RhinoJScriptEvaluator.convertJsToJava(this.instanceEval(task, expression, params));
        }
        catch (EvaluatorException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
        if (result instanceof byte[][]) {
            ArrayList<byte[]> resultsArray = new ArrayList<byte[]>();
            for (byte[] resultValue : (byte[][])result) {
                resultsArray.add(resultValue);
            }
            return resultsArray;
        }
        if (result instanceof byte[]) {
            ArrayList<byte[]> resultsArray = new ArrayList<byte[]>();
            byte[] resultAsByteArray = (byte[])result;
            if (resultAsByteArray != null && resultAsByteArray.length > 0) {
                resultsArray.add(resultAsByteArray);
            }
            return resultsArray;
        }
        if (result instanceof String) {
            ArrayList<byte[]> resultsArray = new ArrayList<byte[]>();
            String resultAsString = (String)result;
            if (resultAsString != null && resultAsString.length() > 0) {
                resultsArray.add(resultAsString.getBytes());
            }
            return resultsArray;
        }
        if (result instanceof List) {
            ArrayList<byte[]> resultsArray = new ArrayList<byte[]>();
            for (Object resultValue : (List)result) {
                if (resultValue instanceof byte[]) {
                    resultsArray.add((byte[])resultValue);
                    continue;
                }
                resultsArray.add(resultValue.toString().getBytes());
            }
            return resultsArray;
        }
        if (result instanceof Set) {
            ArrayList<byte[]> resultsArray = new ArrayList<byte[]>();
            for (Object resultValue : (Set)result) {
                if (resultValue instanceof byte[]) {
                    resultsArray.add((byte[])resultValue);
                    continue;
                }
                resultsArray.add(resultValue.toString().getBytes());
            }
            return resultsArray;
        }
        if (result == null) {
            return null;
        }
        ArrayList<byte[]> resultsArray = new ArrayList<byte[]>();
        if (result != null) {
            resultsArray.add(result.toString().getBytes());
        }
        return resultsArray;
    }

    @Override
    public byte[] evalToByteArray(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        Object result = null;
        try {
            result = RhinoJScriptEvaluator.convertJsToJava(this.instanceEval(task, expression, params));
        }
        catch (EvaluatorException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
        if (result instanceof byte[]) {
            return (byte[])result;
        }
        if (result instanceof String) {
            return ((String)result).getBytes();
        }
        return result.toString().getBytes();
    }

    @Override
    public Boolean evalToBoolean(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        try {
            return (Boolean)Context.jsToJava((Object)this.instanceEval(task, expression, params), Boolean.class);
        }
        catch (EvaluatorException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object instanceEval(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        Iterator iterator;
        Object jsObj;
        RhinoDebugger rhinoDebugger = null;
        HashMap<String, Object> localParams = new HashMap<String, Object>();
        if (params != null) {
            localParams.putAll(params);
        }
        String expressionImport = "with (new JavaImporter(Packages.org.lsc.utils.directory)) {with (new JavaImporter(Packages.org.lsc.utils)) {\n" + expression + "\n}}";
        ContextFactory factory = new ContextFactory();
        if (this.debug) {
            rhinoDebugger = new RhinoDebugger(expressionImport, factory);
        }
        this.cx = factory.enterContext();
        ScriptableObject scope = this.cx.initStandardObjects();
        Script script = this.cx.compileString(expressionImport, "<cmd>", 1, null);
        if (!localParams.containsKey("ldap") && task.getDestinationService() instanceof AbstractSimpleJndiService) {
            ScriptableJndiServices dstSjs = new ScriptableJndiServices();
            dstSjs.setJndiServices(((AbstractSimpleJndiService)((Object)task.getDestinationService())).getJndiServices());
            localParams.put("ldap", dstSjs);
        }
        if (!localParams.containsKey("srcLdap") && task.getSourceService() instanceof AbstractSimpleJndiService) {
            ScriptableJndiServices srcSjs = new ScriptableJndiServices();
            srcSjs.setJndiServices(((AbstractSimpleJndiService)((Object)task.getSourceService())).getJndiServices());
            localParams.put("srcLdap", srcSjs);
        }
        for (Map.Entry entry : localParams.entrySet()) {
            jsObj = Context.javaToJS(entry.getValue(), (Scriptable)scope);
            ScriptableObject.putProperty((Scriptable)scope, (String)((String)entry.getKey()), jsObj);
        }
        Object ret = null;
        try {
            ArrayList<Script> arrayList = new ArrayList<Script>();
            if (task.getScriptIncludes() != null) {
                for (File file : task.getScriptIncludes()) {
                    if (!"js".equals(FilenameUtils.getExtension((String)file.getAbsolutePath()))) continue;
                    Script include = this.cx.compileReader((Reader)new FileReader(file), file.getAbsolutePath(), 1, null);
                    arrayList.add(include);
                }
            }
            if (this.debug) {
                rhinoDebugger.initContext(this.cx, (Scriptable)scope, script);
                jsObj = Context.javaToJS((Object)rhinoDebugger, (Scriptable)scope);
                ScriptableObject.putProperty((Scriptable)scope, (String)"rhinoDebugger", (Object)jsObj);
                for (Script include : arrayList) {
                    rhinoDebugger.execInclude(include);
                }
                ret = rhinoDebugger.exec();
            } else {
                for (Script script2 : arrayList) {
                    script2.exec(this.cx, (Scriptable)scope);
                }
                ret = script.exec(this.cx, (Scriptable)scope);
            }
        }
        catch (EcmaError ecmaError) {
            LOGGER.error(ecmaError.toString());
            LOGGER.debug(ecmaError.toString(), (Throwable)ecmaError);
            iterator = null;
            return iterator;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            LOGGER.error(exception.toString());
            LOGGER.debug(exception.toString(), (Throwable)exception);
            iterator = null;
            return iterator;
        }
        finally {
            if (this.debug) {
                rhinoDebugger.run();
            }
            Context.exit();
        }
        return ret;
    }

    private static Object convertJsToJava(Object src) {
        if (src == null) {
            return null;
        }
        if (src.getClass().getName().equals("sun.org.mozilla.javascript.internal.NativeJavaObject")) {
            return Context.jsToJava((Object)src, Object.class);
        }
        if (src.getClass().getName().equals("sun.org.mozilla.javascript.internal.NativeArray")) {
            try {
                Method getMethod = src.getClass().getMethod("get", Integer.TYPE, Class.forName("sun.org.mozilla.javascript.internal.Scriptable"));
                Object length = src.getClass().getMethod("getLength", new Class[0]).invoke(src, new Object[0]);
                Object[] retarr = new Object[Integer.parseInt(length.toString())];
                for (int index = 0; index < retarr.length; ++index) {
                    retarr[index] = getMethod.invoke(src, index, null);
                }
                return retarr;
            }
            catch (Exception e) {
                LOGGER.error(e.toString());
                LOGGER.debug(e.toString(), (Throwable)e);
            }
        } else if (src == UniqueTag.NOT_FOUND || src == UniqueTag.NULL_VALUE) {
            return null;
        }
        return src;
    }
}

