/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils;

import java.util.HashMap;
import java.util.Map;
import org.lsc.jndi.JndiServices;
import org.lsc.utils.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequencesFactory {
    private static SequencesFactory instance;
    private Map<String, Sequence> sequences;
    private static final Logger LOGGER;
    private JndiServices jndiServices;

    private SequencesFactory(JndiServices jndiServices) {
        this.jndiServices = jndiServices;
        this.sequences = new HashMap<String, Sequence>();
    }

    public static SequencesFactory getInstance(JndiServices services) {
        if (instance == null) {
            LOGGER.info("Initializing the sequences factory.");
            instance = new SequencesFactory(services);
        }
        return instance;
    }

    public int getNextValue(String dn, String attributeName) {
        String hash = SequencesFactory.getHash(dn, attributeName);
        LOGGER.debug("Getting the next value for the following sequence {}", (Object)hash);
        Sequence sq = this.getSequence(dn, attributeName, hash);
        if (sq == null) {
            LOGGER.debug("Couldn't get the sequence {}. Returning -1.", (Object)hash);
            return -1;
        }
        return sq.getNextValue();
    }

    public int getCurrentValue(String dn, String attributeName) {
        String hash = SequencesFactory.getHash(dn, attributeName);
        LOGGER.debug("Getting the current value for the following sequence {}", (Object)hash);
        Sequence sq = this.getSequence(dn, attributeName, hash);
        if (sq == null) {
            LOGGER.debug("Couldn't get the sequence {}. Returning -1.", (Object)hash);
            return -1;
        }
        return sq.getCurrentValue();
    }

    private Sequence getSequence(String dn, String attributeName, String hash) {
        if (this.sequences.containsKey(hash)) {
            return this.sequences.get(hash);
        }
        Sequence seq = new Sequence(this.jndiServices);
        if (!seq.load(dn, attributeName, 0)) {
            return null;
        }
        this.sequences.put(hash, seq);
        return seq;
    }

    private static String getHash(String dn, String attributeName) {
        if (dn == null || attributeName == null) {
            return null;
        }
        return attributeName + "/" + dn;
    }

    static {
        LOGGER = LoggerFactory.getLogger(SequencesFactory.class);
    }
}

