/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils.directory;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AD {
    private static final Long UNIX_EPOCH_IN_AD_TIME = 116444736000000000L;
    private static final Map<Integer, Integer> setHexValue = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> unsetHexValue = new HashMap<Integer, Integer>();
    public static final Integer UAC_SCRIPT = 1;
    public static final Integer UAC_ACCOUNTDISABLE = 2;
    public static final Integer UAC_HOMEDIR_REQUIRED = 8;
    public static final Integer UAC_LOCKOUT = 16;
    public static final Integer UAC_PASSWD_NOTREQD = 32;
    public static final Integer UAC_PASSWD_CANT_CHANGE = 64;
    public static final Integer UAC_ENCRYPTED_TEXT_PWD_ALLOWED = 128;
    public static final Integer UAC_TEMP_DUPLICATE_ACCOUNT = 256;
    public static final Integer UAC_NORMAL_ACCOUNT = 512;
    public static final Integer UAC_INTERDOMAIN_TRUST_ACCOUNT = 2048;
    public static final Integer UAC_WORKSTATION_TRUST_ACCOUNT = 4096;
    public static final Integer UAC_SERVER_TRUST_ACCOUNT = 8192;
    public static final Integer UAC_DONT_EXPIRE_PASSWORD = 65536;
    public static final Integer UAC_MNS_LOGON_ACCOUNT = 131072;
    public static final Integer UAC_SMARTCARD_REQUIRED = 262144;
    public static final Integer UAC_TRUSTED_FOR_DELEGATION = 524288;
    public static final Integer UAC_NOT_DELEGATED = 0x100000;
    public static final Integer UAC_USE_DES_KEY_ONLY = 0x200000;
    public static final Integer UAC_DONT_REQ_PREAUTH = 0x400000;
    public static final Integer UAC_PASSWORD_EXPIRED = 0x800000;
    public static final Integer UAC_TRUSTED_TO_AUTH_FOR_DELEGATION = 0x1000000;
    public static final Integer UAC_SET_SCRIPT = UAC_SCRIPT;
    public static final Integer UAC_UNSET_SCRIPT = -UAC_SCRIPT.intValue();
    public static final Integer UAC_SET_ACCOUNTDISABLE = UAC_ACCOUNTDISABLE;
    public static final Integer UAC_UNSET_ACCOUNTDISABLE = -UAC_ACCOUNTDISABLE.intValue();
    public static final Integer UAC_SET_HOMEDIR_REQUIRED = UAC_HOMEDIR_REQUIRED;
    public static final Integer UAC_UNSET_HOMEDIR_REQUIRED = -UAC_HOMEDIR_REQUIRED.intValue();
    public static final Integer UAC_SET_LOCKOUT = UAC_LOCKOUT;
    public static final Integer UAC_UNSET_LOCKOUT = -UAC_LOCKOUT.intValue();
    public static final Integer UAC_SET_PASSWD_NOTREQD = UAC_PASSWD_NOTREQD;
    public static final Integer UAC_UNSET_PASSWD_NOTREQD = -UAC_PASSWD_NOTREQD.intValue();
    public static final Integer UAC_SET_PASSWD_CANT_CHANGE = UAC_PASSWD_CANT_CHANGE;
    public static final Integer UAC_UNSET_PASSWD_CANT_CHANGE = -UAC_PASSWD_CANT_CHANGE.intValue();
    public static final Integer UAC_SET_ENCRYPTED_TEXT_PWD_ALLOWED = UAC_ENCRYPTED_TEXT_PWD_ALLOWED;
    public static final Integer UAC_UNSET_ENCRYPTED_TEXT_PWD_ALLOWED = -UAC_ENCRYPTED_TEXT_PWD_ALLOWED.intValue();
    public static final Integer UAC_SET_TEMP_DUPLICATE_ACCOUNT = UAC_TEMP_DUPLICATE_ACCOUNT;
    public static final Integer UAC_UNSET_TEMP_DUPLICATE_ACCOUNT = -UAC_TEMP_DUPLICATE_ACCOUNT.intValue();
    public static final Integer UAC_SET_NORMAL_ACCOUNT = UAC_NORMAL_ACCOUNT;
    public static final Integer UAC_UNSET_NORMAL_ACCOUNT = -UAC_NORMAL_ACCOUNT.intValue();
    public static final Integer UAC_SET_INTERDOMAIN_TRUST_ACCOUNT = UAC_INTERDOMAIN_TRUST_ACCOUNT;
    public static final Integer UAC_UNSET_INTERDOMAIN_TRUST_ACCOUNT = -UAC_INTERDOMAIN_TRUST_ACCOUNT.intValue();
    public static final Integer UAC_SET_WORKSTATION_TRUST_ACCOUNT = UAC_WORKSTATION_TRUST_ACCOUNT;
    public static final Integer UAC_UNSET_WORKSTATION_TRUST_ACCOUNT = -UAC_WORKSTATION_TRUST_ACCOUNT.intValue();
    public static final Integer UAC_SET_SERVER_TRUST_ACCOUNT = UAC_SERVER_TRUST_ACCOUNT;
    public static final Integer UAC_UNSET_SERVER_TRUST_ACCOUNT = -UAC_SERVER_TRUST_ACCOUNT.intValue();
    public static final Integer UAC_SET_DONT_EXPIRE_PASSWORD = UAC_DONT_EXPIRE_PASSWORD;
    public static final Integer UAC_UNSET_DONT_EXPIRE_PASSWORD = -UAC_DONT_EXPIRE_PASSWORD.intValue();
    public static final Integer UAC_SET_MNS_LOGON_ACCOUNT = UAC_MNS_LOGON_ACCOUNT;
    public static final Integer UAC_UNSET_MNS_LOGON_ACCOUNT = -UAC_MNS_LOGON_ACCOUNT.intValue();
    public static final Integer UAC_SET_SMARTCARD_REQUIRED = UAC_SMARTCARD_REQUIRED;
    public static final Integer UAC_UNSET_SMARTCARD_REQUIRED = -UAC_SMARTCARD_REQUIRED.intValue();
    public static final Integer UAC_SET_TRUSTED_FOR_DELEGATION = UAC_TRUSTED_FOR_DELEGATION;
    public static final Integer UAC_UNSET_TRUSTED_FOR_DELEGATION = -UAC_TRUSTED_FOR_DELEGATION.intValue();
    public static final Integer UAC_SET_NOT_DELEGATED = UAC_NOT_DELEGATED;
    public static final Integer UAC_UNSET_NOT_DELEGATED = -UAC_NOT_DELEGATED.intValue();
    public static final Integer UAC_SET_USE_DES_KEY_ONLY = UAC_USE_DES_KEY_ONLY;
    public static final Integer UAC_UNSET_USE_DES_KEY_ONLY = -UAC_USE_DES_KEY_ONLY.intValue();
    public static final Integer UAC_SET_DONT_REQ_PREAUTH = UAC_DONT_REQ_PREAUTH;
    public static final Integer UAC_UNSET_DONT_REQ_PREAUTH = -UAC_DONT_REQ_PREAUTH.intValue();
    public static final Integer UAC_SET_PASSWORD_EXPIRED = UAC_PASSWORD_EXPIRED;
    public static final Integer UAC_UNSET_PASSWORD_EXPIRED = -UAC_PASSWORD_EXPIRED.intValue();
    public static final Integer UAC_SET_TRUSTED_TO_AUTH_FOR_DELEGATION = UAC_TRUSTED_TO_AUTH_FOR_DELEGATION;
    public static final Integer UAC_UNSET_TRUSTED_TO_AUTH_FOR_DELEGATION = -UAC_TRUSTED_TO_AUTH_FOR_DELEGATION.intValue();

    private AD() {
    }

    public static int userAccountControlSet(int origValue, String[] constToApply) {
        int result = origValue;
        for (String str : constToApply) {
            Integer constValue = Integer.parseInt(str);
            if (setHexValue.containsKey(constValue)) {
                result |= setHexValue.get(constValue).intValue();
            }
            if (!unsetHexValue.containsKey(constValue)) continue;
            result &= unsetHexValue.get(constValue).intValue();
        }
        return result;
    }

    public static boolean userAccountControlCheck(int value, String constToCheck) {
        Integer constValue = Integer.parseInt(constToCheck);
        return (value & constValue) > 0;
    }

    public static int userAccountControlToggle(int value, String constToApply) {
        Integer constValue = Integer.parseInt(constToApply);
        if ((value & constValue) == constValue) {
            return value & ~constValue.intValue();
        }
        return value | constValue;
    }

    public static String getUnicodePwd(String password) throws UnsupportedEncodingException {
        String quotedPassword = "\"" + password + "\"";
        return new String(quotedPassword.getBytes("UTF-16LE"));
    }

    public static long aDTimeToUnixTimestamp(long aDTime) {
        return (aDTime - UNIX_EPOCH_IN_AD_TIME) / (long)Math.pow(10.0, 7.0);
    }

    public static long aDTimeToUnixTimestamp(String aDTimeString) {
        Long ts = Long.parseLong(aDTimeString);
        return AD.aDTimeToUnixTimestamp(ts);
    }

    public static long unixTimestampToADTime(long unixTimestamp) {
        return unixTimestamp * (long)Math.pow(10.0, 7.0) + UNIX_EPOCH_IN_AD_TIME;
    }

    public static long unixTimestampToADTime(String unixTimestampString) {
        return AD.unixTimestampToADTime(Long.parseLong(unixTimestampString));
    }

    public static int getNumberOfWeeksSinceLastLogon(String lastLogonTimestamp) {
        if (lastLogonTimestamp == null || lastLogonTimestamp.length() == 0) {
            return 0;
        }
        long secondsToUnixTimeStamp = AD.aDTimeToUnixTimestamp(lastLogonTimestamp);
        long lastLogonTime = new Date().getTime() / 1000L - secondsToUnixTimeStamp;
        return (int)(lastLogonTime / 604800L);
    }

    public static long getAccountExpires(String expireDate, String format) throws ParseException {
        if (expireDate == null || expireDate.length() == 0) {
            return 0L;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        long accountExpiresTimeStampMs = sdf.parse(expireDate).getTime() * (long)Math.pow(10.0, 4.0);
        return accountExpiresTimeStampMs + UNIX_EPOCH_IN_AD_TIME;
    }

    public static long getAccountExpires(String expireDate) throws ParseException {
        return AD.getAccountExpires(expireDate, "yyyy-MM-dd");
    }

    static {
        setHexValue.put(UAC_SET_SCRIPT, UAC_SCRIPT);
        unsetHexValue.put(UAC_UNSET_SCRIPT, ~UAC_SCRIPT.intValue());
        setHexValue.put(UAC_SET_ACCOUNTDISABLE, UAC_ACCOUNTDISABLE);
        unsetHexValue.put(UAC_UNSET_ACCOUNTDISABLE, ~UAC_ACCOUNTDISABLE.intValue());
        setHexValue.put(UAC_SET_HOMEDIR_REQUIRED, UAC_HOMEDIR_REQUIRED);
        unsetHexValue.put(UAC_UNSET_HOMEDIR_REQUIRED, ~UAC_HOMEDIR_REQUIRED.intValue());
        setHexValue.put(UAC_SET_LOCKOUT, UAC_LOCKOUT);
        unsetHexValue.put(UAC_UNSET_LOCKOUT, ~UAC_LOCKOUT.intValue());
        setHexValue.put(UAC_SET_PASSWD_NOTREQD, UAC_PASSWD_NOTREQD);
        unsetHexValue.put(UAC_UNSET_PASSWD_NOTREQD, ~UAC_PASSWD_NOTREQD.intValue());
        setHexValue.put(UAC_SET_PASSWD_CANT_CHANGE, UAC_PASSWD_CANT_CHANGE);
        unsetHexValue.put(UAC_UNSET_PASSWD_CANT_CHANGE, ~UAC_PASSWD_CANT_CHANGE.intValue());
        setHexValue.put(UAC_SET_ENCRYPTED_TEXT_PWD_ALLOWED, UAC_ENCRYPTED_TEXT_PWD_ALLOWED);
        unsetHexValue.put(UAC_UNSET_ENCRYPTED_TEXT_PWD_ALLOWED, ~UAC_ENCRYPTED_TEXT_PWD_ALLOWED.intValue());
        setHexValue.put(UAC_SET_TEMP_DUPLICATE_ACCOUNT, UAC_TEMP_DUPLICATE_ACCOUNT);
        unsetHexValue.put(UAC_UNSET_TEMP_DUPLICATE_ACCOUNT, ~UAC_TEMP_DUPLICATE_ACCOUNT.intValue());
        setHexValue.put(UAC_SET_NORMAL_ACCOUNT, UAC_NORMAL_ACCOUNT);
        unsetHexValue.put(UAC_UNSET_NORMAL_ACCOUNT, ~UAC_NORMAL_ACCOUNT.intValue());
        setHexValue.put(UAC_SET_INTERDOMAIN_TRUST_ACCOUNT, UAC_INTERDOMAIN_TRUST_ACCOUNT);
        unsetHexValue.put(UAC_UNSET_INTERDOMAIN_TRUST_ACCOUNT, ~UAC_INTERDOMAIN_TRUST_ACCOUNT.intValue());
        setHexValue.put(UAC_SET_WORKSTATION_TRUST_ACCOUNT, UAC_WORKSTATION_TRUST_ACCOUNT);
        unsetHexValue.put(UAC_UNSET_WORKSTATION_TRUST_ACCOUNT, ~UAC_WORKSTATION_TRUST_ACCOUNT.intValue());
        setHexValue.put(UAC_SET_SERVER_TRUST_ACCOUNT, UAC_SERVER_TRUST_ACCOUNT);
        unsetHexValue.put(UAC_UNSET_SERVER_TRUST_ACCOUNT, ~UAC_SERVER_TRUST_ACCOUNT.intValue());
        setHexValue.put(UAC_SET_DONT_EXPIRE_PASSWORD, UAC_DONT_EXPIRE_PASSWORD);
        unsetHexValue.put(UAC_UNSET_DONT_EXPIRE_PASSWORD, ~UAC_DONT_EXPIRE_PASSWORD.intValue());
        setHexValue.put(UAC_SET_MNS_LOGON_ACCOUNT, UAC_MNS_LOGON_ACCOUNT);
        unsetHexValue.put(UAC_UNSET_MNS_LOGON_ACCOUNT, ~UAC_MNS_LOGON_ACCOUNT.intValue());
        setHexValue.put(UAC_SET_SMARTCARD_REQUIRED, UAC_SMARTCARD_REQUIRED);
        unsetHexValue.put(UAC_UNSET_SMARTCARD_REQUIRED, ~UAC_SMARTCARD_REQUIRED.intValue());
        setHexValue.put(UAC_SET_TRUSTED_FOR_DELEGATION, UAC_TRUSTED_FOR_DELEGATION);
        unsetHexValue.put(UAC_UNSET_TRUSTED_FOR_DELEGATION, ~UAC_TRUSTED_FOR_DELEGATION.intValue());
        setHexValue.put(UAC_SET_NOT_DELEGATED, UAC_NOT_DELEGATED);
        unsetHexValue.put(UAC_UNSET_NOT_DELEGATED, ~UAC_NOT_DELEGATED.intValue());
        setHexValue.put(UAC_SET_USE_DES_KEY_ONLY, UAC_USE_DES_KEY_ONLY);
        unsetHexValue.put(UAC_UNSET_USE_DES_KEY_ONLY, ~UAC_USE_DES_KEY_ONLY.intValue());
        setHexValue.put(UAC_SET_DONT_REQ_PREAUTH, UAC_DONT_REQ_PREAUTH);
        unsetHexValue.put(UAC_UNSET_DONT_REQ_PREAUTH, ~UAC_DONT_REQ_PREAUTH.intValue());
        setHexValue.put(UAC_SET_PASSWORD_EXPIRED, UAC_PASSWORD_EXPIRED);
        unsetHexValue.put(UAC_UNSET_PASSWORD_EXPIRED, ~UAC_PASSWORD_EXPIRED.intValue());
        setHexValue.put(UAC_SET_TRUSTED_TO_AUTH_FOR_DELEGATION, UAC_TRUSTED_TO_AUTH_FOR_DELEGATION);
        unsetHexValue.put(UAC_UNSET_TRUSTED_TO_AUTH_FOR_DELEGATION, ~UAC_TRUSTED_TO_AUTH_FOR_DELEGATION.intValue());
    }
}

