/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.lsc.Configuration;
import org.lsc.configuration.EncryptionType;
import org.lsc.configuration.LscConfiguration;
import org.lsc.exception.LscException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmetricEncryption {
    private static final Logger LOGGER = LoggerFactory.getLogger(SymmetricEncryption.class);
    public static final int DEFAULT_CIPHER_STRENGTH = 128;
    public static final String DEFAULT_CIPHER_ALGORITHM = "AES";
    private int strength;
    private String algorithm;
    private String keyPath;
    private Cipher cipherDecrypt;
    private Cipher cipherEncrypt;
    private Provider securityProvider;

    public SymmetricEncryption() throws GeneralSecurityException {
        this.securityProvider = new BouncyCastleProvider();
        Security.addProvider(this.securityProvider);
    }

    public SymmetricEncryption(EncryptionType encryption) throws GeneralSecurityException {
        if (encryption == null) {
            throw new RuntimeException("lsc>security>encryption node of the LSC configuration cannot be null !");
        }
        if (encryption.getKeyfile() == null) {
            throw new RuntimeException("lsc>security>encryption>keyfile node of the LSC configuration cannot be null !");
        }
        if (encryption.getAlgorithm() == null) {
            throw new RuntimeException("lsc>security>encryption>algorithm node of the LSC configuration cannot be null !");
        }
        this.securityProvider = new BouncyCastleProvider();
        this.algorithm = encryption.getAlgorithm();
        this.strength = encryption.getStrength();
        this.keyPath = encryption.getKeyfile();
        Security.addProvider(this.securityProvider);
    }

    public byte[] encrypt(byte[] toEncrypt) throws GeneralSecurityException {
        return this.cipherEncrypt.doFinal(toEncrypt);
    }

    public byte[] decrypt(byte[] toDecrypt) throws GeneralSecurityException {
        return this.cipherDecrypt.doFinal(toDecrypt);
    }

    public boolean generateDefaultRandomKeyFile() throws NoSuchAlgorithmException, NoSuchProviderException {
        File keypath = new File(Configuration.getConfigurationDirectory(), "lsc.key");
        if (keypath.exists()) {
            LOGGER.error("Existing key file in {}. Please move it away before generating a new key !", (Object)keypath.getAbsolutePath());
            return false;
        }
        boolean status = this.generateRandomKeyFile(keypath.getAbsolutePath(), this.algorithm, this.strength);
        this.keyPath = keypath.getAbsolutePath();
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generateRandomKeyFile(String keyPath, String algo, int strength) throws NoSuchAlgorithmException, NoSuchProviderException {
        OutputStream os = null;
        try {
            KeyGenerator kg = KeyGenerator.getInstance(algo, this.securityProvider.getName());
            SecretKey cipherKey = kg.generateKey();
            SecureRandom sr = new SecureRandom();
            kg.init(strength, sr);
            os = new FileOutputStream(keyPath);
            os.write(cipherKey.getEncoded());
        }
        catch (IOException e) {
            LOGGER.error("Unable to write new generated key in " + keyPath + ". Encountered exception is : " + e.getLocalizedMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static String getKeyPath() {
        return LscConfiguration.getSecurity().getEncryption().getKeyfile();
    }

    public static String getAlgorithm() {
        return LscConfiguration.getSecurity().getEncryption().getAlgorithm();
    }

    public static int getStrength() {
        return LscConfiguration.getSecurity().getEncryption().getStrength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initialize() throws GeneralSecurityException {
        InputStream input = null;
        boolean fail = false;
        try {
            input = new FileInputStream(new File(this.keyPath));
            byte[] data = new byte[this.strength / 8];
            input.read(data);
            SecretKeySpec key = new SecretKeySpec(data, this.algorithm);
            this.cipherEncrypt = Cipher.getInstance(this.algorithm);
            this.cipherEncrypt.init(1, key);
            this.cipherDecrypt = Cipher.getInstance(this.algorithm);
            this.cipherDecrypt.init(2, key);
        }
        catch (IOException e) {
            fail = true;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (fail) {
            LOGGER.error("Error reading the key for SymmetricEncryption! ({})", (Object)this.keyPath);
            return false;
        }
        return true;
    }

    public static void main(String[] argv) {
        try {
            Options options = new Options();
            options.addOption("f", "cfg", true, "Specify configuration directory");
            CommandLine cmdLine = new GnuParser().parse(options, argv);
            if (cmdLine.getOptions().length > 0 && cmdLine.hasOption("f")) {
                Configuration.setUp(cmdLine.getOptionValue("f"), false);
            } else {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("lsc", options);
                System.exit(1);
            }
        }
        catch (ParseException e) {
            StringBuilder sbf = new StringBuilder();
            for (String arg : argv) {
                sbf.append(arg).append(" ");
            }
            LOGGER.error("Unable to parse options : {}({})", (Object)sbf.toString(), (Object)e);
            System.exit(1);
        }
        catch (LscException e) {
            LOGGER.error("Something goes wrong while loading configuration: " + e.toString(), (Throwable)e);
            System.exit(2);
        }
        try {
            if (LscConfiguration.getSecurity() == null) {
                throw new RuntimeException("lsc>security node of the LSC configuration cannot be null !");
            }
            if (LscConfiguration.getSecurity().getEncryption() == null) {
                throw new RuntimeException("lsc>security>encryption node of the LSC configuration cannot be null !");
            }
            SymmetricEncryption se = new SymmetricEncryption(LscConfiguration.getSecurity().getEncryption());
            if (se.generateDefaultRandomKeyFile()) {
                LOGGER.info("Key generated: {}. Do not forget to check the lsc>security>encryption>keyfile node value in your configuration file !", (Object)se.keyPath);
            }
        }
        catch (GeneralSecurityException ex) {
            LOGGER.debug(ex.toString(), (Throwable)ex);
        }
    }
}

