/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm;

import bitronix.tm.BitronixTransactionMBean;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixMultiSystemException;
import bitronix.tm.internal.BitronixRollbackException;
import bitronix.tm.internal.BitronixRollbackSystemException;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.internal.BitronixXAException;
import bitronix.tm.internal.TransactionStatusChangeListener;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.internal.XAResourceManager;
import bitronix.tm.journal.Journal;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.twopc.Committer;
import bitronix.tm.twopc.PhaseException;
import bitronix.tm.twopc.Preparer;
import bitronix.tm.twopc.Rollbacker;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.ManagementRegistrar;
import bitronix.tm.utils.Scheduler;
import bitronix.tm.utils.Uid;
import bitronix.tm.utils.UidGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitronixTransaction
implements Transaction,
BitronixTransactionMBean {
    private static final Logger log = LoggerFactory.getLogger(BitronixTransaction.class);
    private int status = 6;
    private XAResourceManager resourceManager;
    private Scheduler synchronizationScheduler = new Scheduler();
    private List transactionStatusListeners = new ArrayList();
    private boolean timeout = false;
    private Date timeoutDate;
    private Preparer preparer = new Preparer(TransactionManagerServices.getExecutor());
    private Committer committer = new Committer(TransactionManagerServices.getExecutor());
    private Rollbacker rollbacker = new Rollbacker(TransactionManagerServices.getExecutor());
    private String threadName;
    private Date startDate;

    public BitronixTransaction() {
        Uid gtrid = UidGenerator.generateUid();
        if (log.isDebugEnabled()) {
            log.debug("creating new transaction with GTRID [" + gtrid + "]");
        }
        this.resourceManager = new XAResourceManager(gtrid);
        this.threadName = Thread.currentThread().getName();
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public boolean enlistResource(XAResource xaResource) throws RollbackException, IllegalStateException, SystemException {
        if (this.status == 6) {
            throw new IllegalStateException("transaction hasn't started yet");
        }
        if (this.status == 1) {
            throw new BitronixRollbackException("transaction has been marked as rollback only");
        }
        if (this.isDone()) {
            throw new IllegalStateException("transaction started or finished 2PC, cannot enlist any more resource");
        }
        XAResourceHolder resourceHolder = ResourceRegistrar.findXAResourceHolder(xaResource);
        if (resourceHolder == null) {
            throw new BitronixSystemException("unknown XAResource " + xaResource + ", it does not belong to a registered resource");
        }
        XAResourceHolderState resourceHolderState = new XAResourceHolderState(resourceHolder, resourceHolder.getResourceBean());
        resourceHolderState.setTransactionTimeoutDate(this.timeoutDate);
        try {
            this.resourceManager.enlist(resourceHolderState);
        }
        catch (XAException ex) {
            if (BitronixXAException.isUnilateralRollback(ex)) {
                this.setStatus(1);
                throw new BitronixRollbackException("resource " + resourceHolderState + " unilaterally rolled back, error=" + Decoder.decodeXAExceptionErrorCode(ex), ex);
            }
            throw new BitronixSystemException("cannot enlist " + resourceHolderState + ", error=" + Decoder.decodeXAExceptionErrorCode(ex), ex);
        }
        resourceHolder.putXAResourceHolderState(resourceHolderState.getXid(), resourceHolderState);
        return true;
    }

    public boolean delistResource(XAResource xaResource, int flag) throws IllegalStateException, SystemException {
        if (this.status == 6) {
            throw new IllegalStateException("transaction hasn't started yet");
        }
        if (flag != 0x4000000 && flag != 0x2000000 && flag != 0x20000000) {
            throw new BitronixSystemException("can only delist with SUCCESS, SUSPEND, FAIL - was: " + Decoder.decodeXAResourceFlag(flag));
        }
        if (this.isWorking()) {
            throw new IllegalStateException("transaction is being committed or rolled back, cannot delist any resource now");
        }
        XAResourceHolder resourceHolder = ResourceRegistrar.findXAResourceHolder(xaResource);
        if (resourceHolder == null) {
            throw new BitronixSystemException("unknown XAResource " + xaResource + ", it does not belong to a registered resource");
        }
        Map statesForGtrid = resourceHolder.getXAResourceHolderStatesForGtrid(this.resourceManager.getGtrid());
        Iterator statesForGtridIt = statesForGtrid.values().iterator();
        boolean result = false;
        ArrayList<BitronixSystemException> exceptions = new ArrayList<BitronixSystemException>();
        ArrayList<XAResourceHolderState> resourceStates = new ArrayList<XAResourceHolderState>();
        while (statesForGtridIt.hasNext()) {
            XAResourceHolderState resourceHolderState = (XAResourceHolderState)statesForGtridIt.next();
            try {
                result &= this.delistResource(resourceHolderState, flag);
            }
            catch (BitronixSystemException ex) {
                if (log.isDebugEnabled()) {
                    log.debug("failed to delist resource state " + resourceHolderState);
                }
                exceptions.add(ex);
                resourceStates.add(resourceHolderState);
            }
        }
        if (!exceptions.isEmpty()) {
            BitronixMultiSystemException multiSystemException = new BitronixMultiSystemException("error delisting resource", exceptions, resourceStates);
            if (!multiSystemException.isUnilateralRollback()) {
                throw multiSystemException;
            }
            if (log.isDebugEnabled()) {
                log.debug("unilateral rollback of resource " + resourceHolder, (Throwable)((Object)multiSystemException));
            }
        }
        return result;
    }

    private boolean delistResource(XAResourceHolderState resourceHolderState, int flag) throws BitronixSystemException {
        try {
            return this.resourceManager.delist(resourceHolderState, flag);
        }
        catch (XAException ex) {
            this.setStatus(1);
            if (BitronixXAException.isUnilateralRollback(ex)) {
                throw new BitronixRollbackSystemException("resource " + resourceHolderState + " unilaterally rolled back, error=" + Decoder.decodeXAExceptionErrorCode(ex), ex);
            }
            throw new BitronixSystemException("cannot delist " + resourceHolderState + ", error=" + Decoder.decodeXAExceptionErrorCode(ex), ex);
        }
    }

    public void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
        if (this.status == 6) {
            throw new IllegalStateException("transaction hasn't started yet");
        }
        if (this.status == 1) {
            throw new BitronixRollbackException("transaction has been marked as rollback only");
        }
        if (this.isDone()) {
            throw new IllegalStateException("transaction is done, cannot register any more synchronization");
        }
        if (log.isDebugEnabled()) {
            log.debug("registering synchronization " + synchronization);
        }
        this.synchronizationScheduler.add(synchronization, 0);
    }

    public Scheduler getSynchronizationScheduler() {
        return this.synchronizationScheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        if (this.status == 6) {
            throw new IllegalStateException("transaction hasn't started yet");
        }
        if (this.isDone()) {
            throw new IllegalStateException("transaction is done, cannot commit it");
        }
        TransactionManagerServices.getTaskScheduler().cancelTransactionTimeout(this);
        this.fireBeforeCompletionEvent();
        if (this.timedOut()) {
            if (log.isDebugEnabled()) {
                log.debug("transaction timed out");
            }
            this.rollback();
            throw new BitronixRollbackException("transaction timed out and has been rolled back");
        }
        if (this.status == 1) {
            if (log.isDebugEnabled()) {
                log.debug("transaction marked as rollback only");
            }
            this.rollback();
            throw new BitronixRollbackException("transaction was marked as rollback only and has been rolled back");
        }
        try {
            List interestedResources;
            try {
                this.delistUnclosedResources(0x4000000);
            }
            catch (BitronixRollbackException ex) {
                this.rollbackPrepareFailure(ex);
                throw new BitronixRollbackException("unilateral resource rollback caused transaction rollback", (Throwable)((Object)ex));
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("committing, " + this.resourceManager.size() + " enlisted resource(s)");
                }
                interestedResources = this.preparer.prepare(this);
            }
            catch (RollbackException ex) {
                if (log.isDebugEnabled()) {
                    log.debug("caught rollback exception during prepare, trying to rollback");
                }
                this.rollbackPrepareFailure(ex);
                throw new BitronixRollbackException("transaction failed to prepare: " + this, ex);
            }
            if (log.isDebugEnabled()) {
                log.debug(interestedResources.size() + " interested resource(s)");
            }
            this.committer.commit(this, interestedResources);
            if (log.isDebugEnabled()) {
                log.debug("successfully committed " + this);
            }
        }
        finally {
            this.fireAfterCompletionEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SystemException {
        if (this.status == 6) {
            throw new IllegalStateException("transaction hasn't started yet");
        }
        if (this.isDone()) {
            throw new IllegalStateException("transaction is done, cannot roll it back");
        }
        TransactionManagerServices.getTaskScheduler().cancelTransactionTimeout(this);
        try {
            block12: {
                try {
                    this.delistUnclosedResources(0x4000000);
                }
                catch (BitronixRollbackException ex) {
                    if (!log.isDebugEnabled()) break block12;
                    log.debug("some resource(s) unilaterally rolled back", (Throwable)((Object)ex));
                }
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("rolling back, " + this.resourceManager.size() + " enlisted resource(s)");
                }
                this.rollbacker.rollback(this, this.resourceManager.getAllResources());
                if (log.isDebugEnabled()) {
                    log.debug("successfully rolled back " + this);
                }
            }
            catch (HeuristicMixedException ex) {
                throw new BitronixSystemException("transaction partly committed and partly rolled back. Resources are now inconsistent !", ex);
            }
            catch (HeuristicCommitException ex) {
                throw new BitronixSystemException("transaction committed instead of rolled back. Resources are now inconsistent !", ex);
            }
        }
        finally {
            this.fireAfterCompletionEvent();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.status == 6) {
            throw new IllegalStateException("transaction hasn't started yet");
        }
        if (this.isDone()) {
            throw new IllegalStateException("transaction is done, cannot change its status");
        }
        this.setStatus(1);
    }

    public XAResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void timeout() throws BitronixSystemException {
        this.timeout = true;
        this.setStatus(1);
        log.warn("transaction timed out: " + this);
    }

    public boolean timedOut() {
        return this.timeout;
    }

    public void setActive(int timeout) throws IllegalStateException, SystemException {
        if (this.status != 6) {
            throw new IllegalStateException("transaction has already started");
        }
        this.setStatus(0);
        this.startDate = new Date();
        this.timeoutDate = new Date(System.currentTimeMillis() + (long)timeout * 1000L);
        TransactionManagerServices.getTaskScheduler().scheduleTransactionTimeout(this, this.timeoutDate);
    }

    public void setStatus(int status) throws BitronixSystemException {
        this.setStatus(status, this.resourceManager.collectUniqueNames());
    }

    public void setStatus(int status, Set uniqueNames) throws BitronixSystemException {
        try {
            boolean force;
            boolean bl = force = this.resourceManager.size() > 1 && status == 8;
            if (log.isDebugEnabled()) {
                log.debug("changing transaction status to " + Decoder.decodeStatus(status) + (force ? " (forced)" : ""));
            }
            int oldStatus = this.status;
            this.status = status;
            Journal journal = TransactionManagerServices.getJournal();
            journal.log(status, this.resourceManager.getGtrid(), uniqueNames);
            if (force) {
                journal.force();
            }
            if (status == 0) {
                ManagementRegistrar.register("bitronix.tm:type=Transaction,Gtrid=" + this.resourceManager.getGtrid(), this);
            }
            this.fireTransactionStatusChangedEvent(oldStatus, status);
        }
        catch (IOException ex) {
            throw new BitronixSystemException("error logging status", ex);
        }
    }

    private void fireTransactionStatusChangedEvent(int oldStatus, int newStatus) {
        if (log.isDebugEnabled()) {
            log.debug("transaction status is changing from " + Decoder.decodeStatus(oldStatus) + " to " + Decoder.decodeStatus(newStatus) + " - executing " + this.transactionStatusListeners.size() + " listener(s)");
        }
        for (int i = 0; i < this.transactionStatusListeners.size(); ++i) {
            TransactionStatusChangeListener listener = (TransactionStatusChangeListener)this.transactionStatusListeners.get(i);
            if (log.isDebugEnabled()) {
                log.debug("executing TransactionStatusChangeListener " + listener);
            }
            listener.statusChanged(oldStatus, newStatus);
            if (!log.isDebugEnabled()) continue;
            log.debug("executed TransactionStatusChangeListener " + listener);
        }
    }

    public void addTransactionStatusChangeListener(TransactionStatusChangeListener listener) {
        this.transactionStatusListeners.add(listener);
    }

    public int hashCode() {
        return this.resourceManager.getGtrid().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BitronixTransaction) {
            BitronixTransaction tx = (BitronixTransaction)obj;
            return this.resourceManager.getGtrid().equals(tx.resourceManager.getGtrid());
        }
        return false;
    }

    public String toString() {
        return "a Bitronix Transaction with GTRID [" + this.resourceManager.getGtrid() + "], status=" + Decoder.decodeStatus(this.status) + ", " + this.resourceManager.size() + " resource(s) enlisted (started " + this.startDate + ")";
    }

    private void delistUnclosedResources(int flag) throws BitronixRollbackException {
        List resources = this.resourceManager.getAllResources();
        ArrayList<XAResourceHolderState> rolledBackResources = new ArrayList<XAResourceHolderState>();
        for (int i = 0; i < resources.size(); ++i) {
            XAResourceHolderState resourceHolderState = (XAResourceHolderState)resources.get(i);
            if (!resourceHolderState.isEnded()) {
                if (log.isDebugEnabled()) {
                    log.debug("found unclosed resource to delist: " + resourceHolderState);
                }
                try {
                    this.delistResource(resourceHolderState, flag);
                }
                catch (BitronixRollbackSystemException ex) {
                    rolledBackResources.add(resourceHolderState);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("resource unilaterally rolled back: " + resourceHolderState, (Throwable)((Object)ex));
                }
                catch (SystemException ex) {
                    rolledBackResources.add(resourceHolderState);
                    log.error("error delisting resource: " + resourceHolderState, (Throwable)ex);
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("no need to delist already closed resource: " + resourceHolderState);
        }
        if (rolledBackResources.size() > 0) {
            throw new BitronixRollbackException("resource(s) " + Decoder.collectResourcesNames(rolledBackResources) + " unilaterally rolled back");
        }
    }

    private void rollbackPrepareFailure(RollbackException rbEx) throws BitronixSystemException {
        List interestedResources = this.resourceManager.getAllResources();
        try {
            this.rollbacker.rollback(this, interestedResources);
            if (log.isDebugEnabled()) {
                log.debug("rollback after prepare failure succeeded");
            }
        }
        catch (Exception ex) {
            PhaseException preparePhaseEx = (PhaseException)rbEx.getCause();
            PhaseException rollbackPhaseEx = (PhaseException)ex.getCause();
            ArrayList exceptions = new ArrayList();
            ArrayList resources = new ArrayList();
            exceptions.addAll(preparePhaseEx.getExceptions());
            exceptions.addAll(rollbackPhaseEx.getExceptions());
            resources.addAll(preparePhaseEx.getResourceStates());
            resources.addAll(rollbackPhaseEx.getResourceStates());
            throw new BitronixSystemException("transaction partially prepared and only partially rolled back. Some resources might be left in doubt !", new PhaseException(exceptions, resources));
        }
    }

    private void fireBeforeCompletionEvent() throws BitronixSystemException {
        if (log.isDebugEnabled()) {
            log.debug("before completion, " + this.synchronizationScheduler.size() + " synchronization(s) to execute");
        }
        Iterator it = this.synchronizationScheduler.reverseIterator();
        while (it.hasNext()) {
            Synchronization synchronization = (Synchronization)it.next();
            try {
                if (log.isDebugEnabled()) {
                    log.debug("executing synchronization " + synchronization);
                }
                synchronization.beforeCompletion();
            }
            catch (RuntimeException ex) {
                if (log.isDebugEnabled()) {
                    log.debug("Synchronization.beforeCompletion() call failed for " + synchronization + ", marking transaction as rollback only - " + ex);
                }
                this.setStatus(1);
                throw ex;
            }
        }
    }

    private void fireAfterCompletionEvent() {
        this.getResourceManager().clearXAResourceHolderStates();
        if (log.isDebugEnabled()) {
            log.debug("after completion, " + this.synchronizationScheduler.size() + " synchronization(s) to execute");
        }
        Iterator it = this.synchronizationScheduler.iterator();
        while (it.hasNext()) {
            Synchronization synchronization = (Synchronization)it.next();
            try {
                if (log.isDebugEnabled()) {
                    log.debug("executing synchronization " + synchronization + " with status=" + Decoder.decodeStatus(this.status));
                }
                synchronization.afterCompletion(this.status);
            }
            catch (Exception ex) {
                log.warn("Synchronization.afterCompletion() call failed for " + synchronization, (Throwable)ex);
            }
        }
        ManagementRegistrar.unregister("bitronix.tm:type=Transaction,Gtrid=" + this.resourceManager.getGtrid());
    }

    private boolean isDone() {
        switch (this.status) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    private boolean isWorking() {
        switch (this.status) {
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public String getGtrid() {
        return this.resourceManager.getGtrid().toString();
    }

    public String getStatusDescription() {
        return Decoder.decodeStatus(this.status);
    }

    public Collection getEnlistedResourcesUniqueNames() {
        return this.resourceManager.collectUniqueNames();
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Date getStartDate() {
        return this.startDate;
    }
}

