/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.jndi;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.ResourceRegistrar;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Referenceable;
import javax.naming.ServiceUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitronixContext
implements Context {
    private static final Logger log = LoggerFactory.getLogger(BitronixContext.class);
    private boolean closed = false;
    private String userTransactionName = TransactionManagerServices.getConfiguration().getJndiUserTransactionName();
    private String synchronizationRegistryName;

    public BitronixContext() {
        if (log.isDebugEnabled()) {
            log.debug("binding transaction manager at name '" + this.userTransactionName + "'");
        }
        this.synchronizationRegistryName = TransactionManagerServices.getConfiguration().getJndiTransactionSynchronizationRegistryName();
        if (log.isDebugEnabled()) {
            log.debug("binding synchronization registry at name '" + this.synchronizationRegistryName + "'");
        }
    }

    private void checkClosed() throws ServiceUnavailableException {
        if (this.closed) {
            throw new ServiceUnavailableException("context is closed");
        }
    }

    public void close() throws NamingException {
        this.closed = true;
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookup(String s) throws NamingException {
        Referenceable o;
        this.checkClosed();
        if (log.isDebugEnabled()) {
            log.debug("looking up '" + s + "'");
        }
        if ((o = this.userTransactionName.equals(s) ? TransactionManagerServices.getTransactionManager() : (this.synchronizationRegistryName.equals(s) ? TransactionManagerServices.getTransactionSynchronizationRegistry() : ResourceRegistrar.get(s))) == null) {
            throw new NameNotFoundException("unable to find a bound object at name '" + s + "'");
        }
        return o;
    }

    public String toString() {
        return "a BitronixContext with userTransactionName='" + this.userTransactionName + "' and synchronizationRegistryName='" + this.synchronizationRegistryName + "'";
    }

    public void bind(Name name, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void bind(String s, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(Name name, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(String s, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void unbind(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(Name name, Name name1) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(String s, String s1) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration listBindings(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NameParser getNameParser(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Name composeName(Name name, Name name1) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String composeName(String s, String s1) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object addToEnvironment(String s, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object removeFromEnvironment(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Hashtable getEnvironment() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }
}

