/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc;

import bitronix.tm.resource.jdbc.JdbcPreparedStatementHandle;
import bitronix.tm.resource.jdbc.LruEvictionListener;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LruStatementCache {
    private static final Logger log = LoggerFactory.getLogger(LruStatementCache.class);
    private int maxSize;
    private LinkedHashMap cache;
    private List evictionListners;
    private int size;

    public LruStatementCache(int maxSize) {
        this.maxSize = maxSize;
        this.cache = new LinkedHashMap(maxSize, 0.75f, true);
        this.evictionListners = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcPreparedStatementHandle get(JdbcPreparedStatementHandle key) {
        LinkedHashMap linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            StatementTracker cached = (StatementTracker)this.cache.get(key);
            if (cached != null) {
                cached.usageCount++;
                key.setDelegate(cached.statement);
                if (log.isDebugEnabled()) {
                    log.debug("delivered from cache with usage count " + cached.usageCount + " statement <" + key + "> in " + key.getPooledConnection());
                }
                return key;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcPreparedStatementHandle put(JdbcPreparedStatementHandle key) {
        LinkedHashMap linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            if (this.maxSize < 1) {
                return null;
            }
            StatementTracker cached = (StatementTracker)this.cache.get(key);
            if (cached == null) {
                if (log.isDebugEnabled()) {
                    log.debug("adding to cache statement <" + key + "> in " + key.getPooledConnection());
                }
                this.cache.put(key, new StatementTracker(key.getDelegateUnchecked()));
                ++this.size;
            } else {
                cached.usageCount--;
                if (log.isDebugEnabled()) {
                    log.debug("returning to cache statement <" + key + "> with usage count " + cached.usageCount + " in " + key.getPooledConnection());
                }
            }
            if (this.size > this.maxSize) {
                this.tryEviction();
            }
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        LinkedHashMap linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            Iterator it = this.cache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                StatementTracker tracker = (StatementTracker)entry.getValue();
                it.remove();
                this.fireEvictionEvent(tracker.statement);
            }
            this.cache.clear();
            this.size = 0;
        }
    }

    private void tryEviction() {
        Iterator it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            StatementTracker tracker = (StatementTracker)entry.getValue();
            if (tracker.usageCount != 0) continue;
            it.remove();
            --this.size;
            JdbcPreparedStatementHandle key = (JdbcPreparedStatementHandle)entry.getKey();
            if (log.isDebugEnabled()) {
                log.debug("evicting from cache statement <" + key + "> " + key.getDelegateUnchecked() + " in " + key.getPooledConnection());
            }
            this.fireEvictionEvent(tracker.statement);
            if (this.size > this.maxSize) continue;
            break;
        }
    }

    private void fireEvictionEvent(Object value) {
        for (int i = 0; i < this.evictionListners.size(); ++i) {
            LruEvictionListener listener = (LruEvictionListener)this.evictionListners.get(i);
            listener.onEviction(value);
        }
    }

    public void addEvictionListener(LruEvictionListener listener) {
        this.evictionListners.add(listener);
    }

    public void removeEvictionListener(LruEvictionListener listener) {
        this.evictionListners.remove(listener);
    }

    private class StatementTracker {
        private PreparedStatement statement;
        private int usageCount;

        private StatementTracker(PreparedStatement stmt) {
            this.statement = stmt;
            this.usageCount = 1;
        }
    }
}

