/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.utils;

import bitronix.tm.utils.Encoder;
import java.util.Arrays;

public final class Uid {
    private byte[] array;
    private int hashCodeValue;
    private String toStringValue;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Uid(byte[] array) {
        this.array = array;
        this.hashCodeValue = Uid.arrayHashCode(array);
        this.toStringValue = Uid.arrayToString(array);
    }

    public byte[] getArray() {
        return this.array;
    }

    public byte[] extractServerId() {
        int serverIdLength = this.array.length - 4 - 8;
        if (serverIdLength < 1) {
            return null;
        }
        byte[] result = new byte[serverIdLength];
        System.arraycopy(this.array, 0, result, 0, serverIdLength);
        return result;
    }

    public long extractTimestamp() {
        return Encoder.bytesToLong(this.array, this.array.length - 4 - 8);
    }

    public int extractSequence() {
        return Encoder.bytesToInt(this.array, this.array.length - 4);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Uid) {
            Uid otherUid = (Uid)obj;
            if (this.hashCodeValue != otherUid.hashCodeValue) {
                return false;
            }
            return Arrays.equals(this.array, otherUid.array);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    public String toString() {
        return this.toStringValue;
    }

    private static int arrayHashCode(byte[] uid) {
        int hash = 0;
        for (int i = uid.length - 1; i > 0; --i) {
            if ((hash <<= 1) < 0) {
                hash |= 1;
            }
            hash ^= uid[i];
        }
        return hash;
    }

    private static String arrayToString(byte[] uid) {
        char[] hexChars = new char[uid.length * 2];
        int c = 0;
        for (int i = 0; i < uid.length; ++i) {
            int v = uid[i] & 0xFF;
            hexChars[c++] = HEX[v >> 4];
            hexChars[c++] = HEX[v & 0xF];
        }
        return new String(hexChars);
    }
}

